{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:37:54 $                                        =}
{========================================================================}
unit Unit3;

{$IFDEF WIN32}
{$H+}
{$ENDIF}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, MMWaveIO, MMObj, MMGauge;

type
  TCvtProgress = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    LblFrom: TLabel;
    LblTo: TLabel;
    Button1: TButton;
    Gauge1: TMMGauge;
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
  public
    Cancel: Boolean;
  end;
            
var
  CvtProgress: TCvtProgress;

implementation

{$R *.DFM}
uses Unit1,Unit2;

{-- TCvtProgress ---------------------------------------------------------}
procedure TCvtProgress.FormShow(Sender: TObject);
var
   FormatTag, Format: String; 

begin
   Cancel := False;

   with MainForm do
   begin
      if not MMACM1.ACMPresent then
      begin
         wioGetFormatName(MMWaveFile1.Wave.PWaveFormat, FormatTag);
         wioGetFormat(MMWaveFile1.Wave.PWaveFormat, Format);
      end
      else MMACM1.GetFormatDescription(MMWaveFile1.Wave.PWaveFormat, FormatTag, Format);

      LblFrom.Caption := FormatTag +' '+ Format;

      if not MMACM1.ACMPresent then
      begin
         wioGetFormatName(FmtDialog.PWaveFormat, FormatTag);
         wioGetFormat(FmtDialog.PWaveFormat, Format);
      end
      else MMACM1.GetFormatDescription(MMACM1.PWaveFormat, FormatTag, Format);

      LblTo.Caption := FormatTag +' '+ Format;
   end;
end;

{-- TCvtProgress ---------------------------------------------------------}
procedure TCvtProgress.Button1Click(Sender: TObject);
begin
   Cancel := True;
end;

{-- TCvtProgress ---------------------------------------------------------}
procedure TCvtProgress.FormClose(Sender: TObject;
                                 var Action: TCloseAction);
begin
   Cancel := True;
end;

end.
